<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MedicalFileShare extends Eloquent {

	protected $table = 'medical_file_shares';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function medicalFile()
	{
		return $this->belongsTo('MedicalFile');
	}

	public function recipient()
	{
		return $this->morphTo();
	}

	public function sender()
	{
		return $this->morphTo();
	}

}