<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMedicalFileSharingRequestsTable extends Migration {

	public function up()
	{
		Schema::create('medical_file_sharing_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('fullfilled')->default(false);
			$table->bigInteger('patient_id')->unsigned()->index();
			$table->bigInteger('appointment_id')->unsigned()->index();
			$table->bigInteger('supplier_id')->unsigned()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('medical_file_sharing_requests');
	}
}