<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceSiteTable extends Migration {

	public function up()
	{
		Schema::create('service_site', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('cost')->unsigned();
			$table->text('description');
			$table->boolean('payable_in_cash')->default(false);
			$table->bigInteger('service_id')->unsigned()->index();
			$table->bigInteger('site_id')->unsigned()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service_site');
	}
}