<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('supplier_id')->unsigned()->index();
			$table->string('name', 255)->index();
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->string('image', 255)->nullable();
			$table->integer('active')->default('1');
			$table->timestamps();
			$table->enum('type', array('admin', 'supervisor', 'moderator'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}