<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Appointment extends Eloquent {

	protected $table = 'appointments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function patient()
	{
		return $this->belongsTo('Patient');
	}

	public function supplier()
	{
		return $this->belongsTo('Patient');
	}

	public function service()
	{
		return $this->belongsTo('ServiceSite', 'service_site_id');
	}

	public function medicalFile()
	{
		return $this->belongsTo('MedicalFile');
	}

	public function patientReminders()
	{
		return $this->hasMany('PatientReminder');
	}

	public function medicalFileSharingRequest()
	{
		return $this->hasOne('MedicalFileSharingrequest');
	}

}