<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MedicalFileSharingrequest extends Eloquent {

	protected $table = 'medical_file_sharing_requests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function patient()
	{
		return $this->belongsTo('Patient');
	}

	public function appointment()
	{
		return $this->belongsTo('Appointment');
	}

	public function supplier()
	{
		return $this->belongsTo('Supplier');
	}

}