<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PatientReminder extends Eloquent {

	protected $table = 'patient_reminders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function appointment()
	{
		return $this->belongsTo('Appointment');
	}

	public function patient()
	{
		return $this->belongsTo('Patient');
	}

	public function supplier()
	{
		return $this->belongsTo('Supplier');
	}

}