<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function sites()
	{
		return $this->belongsToMany('Site')->withPivot('cost', 'description', 'payable_in_cash');
	}

}