<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Site extends Eloquent {

	protected $table = 'sites';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function supplier()
	{
		return $this->belongsTo('Supplier');
	}

	public function users()
	{
		return $this->belongsToMany('User', 'site_user');
	}

	public function schedule()
	{
		return $this->hasOne('Schedule');
	}

	public function unavailableSlots()
	{
		return $this->hasMany('UnavailableSlots');
	}

	public function services()
	{
		return $this->belongsToMany('Service')->withPivot('cost', 'description', 'payable_in_cash');
	}

}