<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Site extends Model 
{

    protected $table = 'sites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function supplier()
    {
        return $this->belongsTo('Supplier');
    }

    public function users()
    {
        return $this->belongsToMany('User', 'site_user');
    }

    public function schedule()
    {
        return $this->hasOne('Schedule');
    }

    public function unavailableSlots()
    {
        return $this->hasMany('UnavailableSlots');
    }

    public function services()
    {
        return $this->belongsToMany('Service')->withPivot('cost', 'description', 'payable_in_cash');
    }

}