<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('patient_id')->unsigned()->index();
			$table->integer('supplier_id')->unsigned()->index();
			$table->bigInteger('service_site_id')->unsigned()->index();
			$table->string('status')->default('requested');
			$table->integer('cost')->unsigned();
			$table->boolean('has_shared_files')->default(false);
			$table->string('video_call_link')->nullable();
			$table->string('video_call_short_link')->nullable();
			$table->string('patient_address')->nullable();
			$table->integer('medical_file_id')->unsigned()->index();
			$table->datetime('scheduled_at');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}