<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->enum('type', array('onsite', 'home', 'web', 'written'));
			$table->integer('duration_in_minutes')->unsigned();
			$table->boolean('active')->default(true);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}