<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnavailableSlotsTable extends Migration {

	public function up()
	{
		Schema::create('unavailable_slots', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('site_id')->unsigned()->index();
			$table->datetime('from');
			$table->datetime('to');
		});
	}

	public function down()
	{
		Schema::drop('unavailable_slots');
	}
}