<?php

namespace App/Models/MarketingSocial;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MarketingSocial extends Model 
{

    protected $table = 'marketing_socials';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function main()
    {
        return $this->belongsTo('MarketingMain', 'marketing_id');
    }

    public function social()
    {
        return $this->belongsTo('Social', 'social_id');
    }

}