<?php

namespace App\Model;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'birth_of_date', 'phone', 'password', 'blood_type_id', 'city_id', 'pin_code');

	public function bloodTypes()
	{
		return $this->belongsToMany('App\Model\BloodType');
	}

	public function posts()
	{
		return $this->belongsToMany('App\Model\Post');
	}

	public function governorates()
	{
		return $this->belongsToMany('App\Model\Governorate');
	}

	public function notifications()
	{
		return $this->belongsToMany('App\Model\Notification');
	}

	public function tokens()
	{
		return $this->hasMany('App\Model\Token');
	}

}