<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnswersTable extends Migration {

	public function up()
	{
		Schema::create('answers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('question_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->integer('cro_id')->unsigned()->nullable();
			$table->integer('site_id')->unsigned()->nullable();
			$table->json('value');
			$table->decimal('statvalue', 16,6)->nullable();
			$table->timestamps();
			$table->integer('section_question_id')->unsigned();
			$table->integer('form_id')->unsigned();
			$table->integer('event_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('answers');
	}
}