<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperatorsTable extends Migration {

	public function up()
	{
		Schema::create('operators', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('cro_id')->unsigned()->nullable()->index();
			$table->integer('site_id')->unsigned()->nullable()->index();
			$table->char('role', 2);
			$table->string('description')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('operators');
	}
}