<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSitesTable extends Migration {

	public function up()
	{
		Schema::create('sites', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('cro_id')->unsigned()->index();
			$table->string('code')->unique();
			$table->string('description')->nullable();
			$table->timestamps();
			$table->integer('patient_target');
		});
	}

	public function down()
	{
		Schema::drop('sites');
	}
}