<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 32)->unique();
			$table->integer('cro_id')->unsigned()->nullable()->index();
			$table->integer('site_id')->unsigned()->nullable()->index();
			$table->integer('operator_id')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->string('status');
			$table->timestamp('started_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}