<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->char('code', 32)->unique();
			$table->boolean('sharable');
			$table->string('label', 255);
			$table->enum('valuetype', array('int', 'float', 'date', 'datetime', 'string', 'boolean', 'set'));
			$table->string('rendertype');
			$table->boolean('required');
			$table->json('definitions');
			$table->timestamps();
			$table->boolean('valuable')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}