<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormsTable extends Migration {

	public function up()
	{
		Schema::create('forms', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->boolean('draft')->default(1);
			$table->timestamps();
			$table->string('categories');
			$table->enum('type', array('QUESTIONNAIRE', 'COMMON_FORM'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('forms');
	}
}