<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('schedule_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->timestamp('completed_at')->nullable();
			$table->string('status')->default('TODO');
			$table->string('completed_pages');
			$table->integer('questionnaire_id')->unsigned()->index();
			$table->integer('diary_id')->unsigned();
			$table->integer('parent_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}