<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQueryTable extends Migration {

	public function up()
	{
		Schema::create('query', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('section_question_id')->unsigned()->index();
			$table->integer('answer_id')->unsigned()->index();
			$table->integer('operator_id')->unsigned();
			$table->string('status')->default('OPEN');
			$table->integer('event_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('query');
	}
}