<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('user_level')->references('id')->on('level')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workexperience', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('education', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('socialmedia', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events_users', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_user_level_foreign');
		});
		Schema::table('workexperience', function(Blueprint $table) {
			$table->dropForeign('workexperience_user_id_foreign');
		});
		Schema::table('education', function(Blueprint $table) {
			$table->dropForeign('education_user_id_foreign');
		});
		Schema::table('socialmedia', function(Blueprint $table) {
			$table->dropForeign('socialmedia_user_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_created_by_foreign');
		});
		Schema::table('events_users', function(Blueprint $table) {
			$table->dropForeign('events_users_event_id_foreign');
		});
		Schema::table('events_users', function(Blueprint $table) {
			$table->dropForeign('events_users_user_id_foreign');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->dropForeign('invites_user_id_foreign');
		});
	}
}