<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->string('email', 191)->unique();
			$table->string('address', 191);
			$table->string('password');
			$table->integer('user_level')->unsigned();
			$table->timestamps();
			$table->ipAddress('ip_address');
			$table->string('remember_token', 100);
			$table->string('invited_by', 191)->nullable();
			$table->string('avatar_url');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}