<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username')->unique();
			$table->string('email')->unique();
			$table->string('password');
			$table->string('f_name');
			$table->string('l_name');
			$table->boolean('sex')->nullable();
			$table->string('photo');
			$table->boolean('confirmed')->default(false);
			$table->string('confirmation_code');
			$table->string('remember_token')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}