<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('telephone', 191);
			$table->integer('city_id')->unsigned();
			$table->integer('region_id')->unsigned();
			$table->string('lng', 191);
			$table->string('lat', 191);
			$table->string('address', 191);
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}