<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('projecto_autores', function(Blueprint $table) {
			$table->foreign('projecto_ID')->references('ID')->on('projectos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projecto_autores', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projecto_grupos', function(Blueprint $table) {
			$table->foreign('projecto_ID')->references('ID')->on('projectos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projecto_area', function(Blueprint $table) {
			$table->foreign('projecto_ID')->references('ID')->on('projectos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projecto_area', function(Blueprint $table) {
			$table->foreign('area_ID')->references('ID')->on('area')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projecto_logs', function(Blueprint $table) {
			$table->foreign('projecto_ID')->references('ID')->on('projectos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projecto_logs', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('utilizador_actividades', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('utilizador_grupos', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('utilizador_grupos', function(Blueprint $table) {
			$table->foreign('posicao_ID')->references('ID')->on('utilizador_posicao')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('utilizador_experiencias', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('utilizador_formacoes', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('utilizador_lingua', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('utilizador_logs', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('grupos', function(Blueprint $table) {
			$table->foreign('director_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('grupo_parceiros', function(Blueprint $table) {
			$table->foreign('grupo_ID')->references('ID')->on('grupos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('grupo_parceiros', function(Blueprint $table) {
			$table->foreign('parceiro_ID')->references('ID')->on('parceiros')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('grupo_parceiros', function(Blueprint $table) {
			$table->foreign('tipo_ID')->references('ID')->on('grupo_tipos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('noticia_idiomas', function(Blueprint $table) {
			$table->foreign('noticia_ID')->references('ID')->on('noticias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('noticia_idiomas', function(Blueprint $table) {
			$table->foreign('idioma_ID')->references('ID')->on('idioma')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('noticia_idiomas', function(Blueprint $table) {
			$table->foreign('estado_ID')->references('ID')->on('noticia_estados')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('noticia_ficheiros', function(Blueprint $table) {
			$table->foreign('noticia_ID')->references('ID')->on('noticias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('noticia_ficheiros', function(Blueprint $table) {
			$table->foreign('ficheiro_ID')->references('ID')->on('ficheiros')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('publicacao_autores', function(Blueprint $table) {
			$table->foreign('publicacao_ID')->references('ID')->on('publicacoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('publicacao_autores', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('publicacao_grupos', function(Blueprint $table) {
			$table->foreign('publicacao_ID')->references('ID')->on('publicacoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('publicacao_grupos', function(Blueprint $table) {
			$table->foreign('grupo_ID')->references('ID')->on('grupos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('publicacao_logs', function(Blueprint $table) {
			$table->foreign('publicacao_ID')->references('ID')->on('publicacoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('publicacao_logs', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('publicacao_area', function(Blueprint $table) {
			$table->foreign('publicacao_ID')->references('ID')->on('publicacoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('publicacao_area', function(Blueprint $table) {
			$table->foreign('area_ID')->references('ID')->on('area')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('relatorio_autores', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('relatorio_grupos', function(Blueprint $table) {
			$table->foreign('relatorio_ID')->references('ID')->on('relatorios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('relatorio_logs', function(Blueprint $table) {
			$table->foreign('relatorio_ID')->references('ID')->on('relatorios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('relatorio_logs', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('relatorio_area', function(Blueprint $table) {
			$table->foreign('relatorio_ID')->references('ID')->on('relatorios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('relatorio_area', function(Blueprint $table) {
			$table->foreign('area_ID')->references('ID')->on('area')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comunicacao_logs', function(Blueprint $table) {
			$table->foreign('comunicacao_ID')->references('ID')->on('comunicacoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comunicacao_logs', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comunicacao_autores', function(Blueprint $table) {
			$table->foreign('comunicacao_ID')->references('ID')->on('comunicacoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comunicacao_autores', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comunicacao_grupos', function(Blueprint $table) {
			$table->foreign('comunicacao_ID')->references('ID')->on('comunicacoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comunicacao_grupos', function(Blueprint $table) {
			$table->foreign('grupo_ID')->references('ID')->on('grupos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comunicacao_area', function(Blueprint $table) {
			$table->foreign('comunicacao_ID')->references('ID')->on('comunicacoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comunicacao_area', function(Blueprint $table) {
			$table->foreign('area_ID')->references('ID')->on('area')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('semiconf_logs', function(Blueprint $table) {
			$table->foreign('semiconf_ID')->references('ID')->on('semiconf')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('semiconf_logs', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('semiconf_autores', function(Blueprint $table) {
			$table->foreign('semiconf_ID')->references('ID')->on('semiconf')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('semiconf_autores', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('semiconf_grupos', function(Blueprint $table) {
			$table->foreign('semiconf_ID')->references('ID')->on('semiconf')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('semiconf_grupos', function(Blueprint $table) {
			$table->foreign('grupo_ID')->references('ID')->on('grupos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('semiconf_area', function(Blueprint $table) {
			$table->foreign('semiconf_ID')->references('ID')->on('semiconf')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('semiconf_area', function(Blueprint $table) {
			$table->foreign('area_ID')->references('ID')->on('area')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('formacao_logs', function(Blueprint $table) {
			$table->foreign('formacao_ID')->references('ID')->on('formacoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('formacao_logs', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('formacao_autores', function(Blueprint $table) {
			$table->foreign('formacao_ID')->references('ID')->on('formacoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('formacao_autores', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('formacao_grupos', function(Blueprint $table) {
			$table->foreign('formacao_ID')->references('ID')->on('formacoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('formacao_grupos', function(Blueprint $table) {
			$table->foreign('grupo_ID')->references('ID')->on('grupos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('formacao_area', function(Blueprint $table) {
			$table->foreign('formacao_ID')->references('ID')->on('formacoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('formacao_area', function(Blueprint $table) {
			$table->foreign('area_ID')->references('ID')->on('area')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modelo_logs', function(Blueprint $table) {
			$table->foreign('modelo_ID')->references('ID')->on('modelos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modelo_logs', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modelo_area', function(Blueprint $table) {
			$table->foreign('modelo_ID')->references('ID')->on('modelos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modelo_area', function(Blueprint $table) {
			$table->foreign('area_ID')->references('ID')->on('area')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modelo_grupos', function(Blueprint $table) {
			$table->foreign('modelo_ID')->references('ID')->on('modelos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modelo_grupos', function(Blueprint $table) {
			$table->foreign('grupo_ID')->references('ID')->on('grupos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modelo_autores', function(Blueprint $table) {
			$table->foreign('utilizador_ID')->references('perfil_ID')->on('utilizadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('projecto_autores', function(Blueprint $table) {
			$table->dropForeign('projecto_autores_projecto_ID_foreign');
		});
		Schema::table('projecto_autores', function(Blueprint $table) {
			$table->dropForeign('projecto_autores_utilizador_ID_foreign');
		});
		Schema::table('projecto_grupos', function(Blueprint $table) {
			$table->dropForeign('projecto_grupos_projecto_ID_foreign');
		});
		Schema::table('projecto_area', function(Blueprint $table) {
			$table->dropForeign('projecto_area_projecto_ID_foreign');
		});
		Schema::table('projecto_area', function(Blueprint $table) {
			$table->dropForeign('projecto_area_area_ID_foreign');
		});
		Schema::table('projecto_logs', function(Blueprint $table) {
			$table->dropForeign('projecto_logs_projecto_ID_foreign');
		});
		Schema::table('projecto_logs', function(Blueprint $table) {
			$table->dropForeign('projecto_logs_utilizador_ID_foreign');
		});
		Schema::table('utilizador_actividades', function(Blueprint $table) {
			$table->dropForeign('utilizador_actividades_utilizador_ID_foreign');
		});
		Schema::table('utilizador_grupos', function(Blueprint $table) {
			$table->dropForeign('utilizador_grupos_utilizador_ID_foreign');
		});
		Schema::table('utilizador_grupos', function(Blueprint $table) {
			$table->dropForeign('utilizador_grupos_posicao_ID_foreign');
		});
		Schema::table('utilizador_experiencias', function(Blueprint $table) {
			$table->dropForeign('utilizador_experiencias_utilizador_ID_foreign');
		});
		Schema::table('utilizador_formacoes', function(Blueprint $table) {
			$table->dropForeign('utilizador_formacoes_utilizador_ID_foreign');
		});
		Schema::table('utilizador_lingua', function(Blueprint $table) {
			$table->dropForeign('utilizador_lingua_utilizador_ID_foreign');
		});
		Schema::table('utilizador_logs', function(Blueprint $table) {
			$table->dropForeign('utilizador_logs_utilizador_ID_foreign');
		});
		Schema::table('grupos', function(Blueprint $table) {
			$table->dropForeign('grupos_director_ID_foreign');
		});
		Schema::table('grupo_parceiros', function(Blueprint $table) {
			$table->dropForeign('grupo_parceiros_grupo_ID_foreign');
		});
		Schema::table('grupo_parceiros', function(Blueprint $table) {
			$table->dropForeign('grupo_parceiros_parceiro_ID_foreign');
		});
		Schema::table('grupo_parceiros', function(Blueprint $table) {
			$table->dropForeign('grupo_parceiros_tipo_ID_foreign');
		});
		Schema::table('noticia_idiomas', function(Blueprint $table) {
			$table->dropForeign('noticia_idiomas_noticia_ID_foreign');
		});
		Schema::table('noticia_idiomas', function(Blueprint $table) {
			$table->dropForeign('noticia_idiomas_idioma_ID_foreign');
		});
		Schema::table('noticia_idiomas', function(Blueprint $table) {
			$table->dropForeign('noticia_idiomas_estado_ID_foreign');
		});
		Schema::table('noticia_ficheiros', function(Blueprint $table) {
			$table->dropForeign('noticia_ficheiros_noticia_ID_foreign');
		});
		Schema::table('noticia_ficheiros', function(Blueprint $table) {
			$table->dropForeign('noticia_ficheiros_ficheiro_ID_foreign');
		});
		Schema::table('publicacao_autores', function(Blueprint $table) {
			$table->dropForeign('publicacao_autores_publicacao_ID_foreign');
		});
		Schema::table('publicacao_autores', function(Blueprint $table) {
			$table->dropForeign('publicacao_autores_utilizador_ID_foreign');
		});
		Schema::table('publicacao_grupos', function(Blueprint $table) {
			$table->dropForeign('publicacao_grupos_publicacao_ID_foreign');
		});
		Schema::table('publicacao_grupos', function(Blueprint $table) {
			$table->dropForeign('publicacao_grupos_grupo_ID_foreign');
		});
		Schema::table('publicacao_logs', function(Blueprint $table) {
			$table->dropForeign('publicacao_logs_publicacao_ID_foreign');
		});
		Schema::table('publicacao_logs', function(Blueprint $table) {
			$table->dropForeign('publicacao_logs_utilizador_ID_foreign');
		});
		Schema::table('publicacao_area', function(Blueprint $table) {
			$table->dropForeign('publicacao_area_publicacao_ID_foreign');
		});
		Schema::table('publicacao_area', function(Blueprint $table) {
			$table->dropForeign('publicacao_area_area_ID_foreign');
		});
		Schema::table('relatorio_autores', function(Blueprint $table) {
			$table->dropForeign('relatorio_autores_utilizador_ID_foreign');
		});
		Schema::table('relatorio_grupos', function(Blueprint $table) {
			$table->dropForeign('relatorio_grupos_relatorio_ID_foreign');
		});
		Schema::table('relatorio_logs', function(Blueprint $table) {
			$table->dropForeign('relatorio_logs_relatorio_ID_foreign');
		});
		Schema::table('relatorio_logs', function(Blueprint $table) {
			$table->dropForeign('relatorio_logs_utilizador_ID_foreign');
		});
		Schema::table('relatorio_area', function(Blueprint $table) {
			$table->dropForeign('relatorio_area_relatorio_ID_foreign');
		});
		Schema::table('relatorio_area', function(Blueprint $table) {
			$table->dropForeign('relatorio_area_area_ID_foreign');
		});
		Schema::table('comunicacao_logs', function(Blueprint $table) {
			$table->dropForeign('comunicacao_logs_comunicacao_ID_foreign');
		});
		Schema::table('comunicacao_logs', function(Blueprint $table) {
			$table->dropForeign('comunicacao_logs_utilizador_ID_foreign');
		});
		Schema::table('comunicacao_autores', function(Blueprint $table) {
			$table->dropForeign('comunicacao_autores_comunicacao_ID_foreign');
		});
		Schema::table('comunicacao_autores', function(Blueprint $table) {
			$table->dropForeign('comunicacao_autores_utilizador_ID_foreign');
		});
		Schema::table('comunicacao_grupos', function(Blueprint $table) {
			$table->dropForeign('comunicacao_grupos_comunicacao_ID_foreign');
		});
		Schema::table('comunicacao_grupos', function(Blueprint $table) {
			$table->dropForeign('comunicacao_grupos_grupo_ID_foreign');
		});
		Schema::table('comunicacao_area', function(Blueprint $table) {
			$table->dropForeign('comunicacao_area_comunicacao_ID_foreign');
		});
		Schema::table('comunicacao_area', function(Blueprint $table) {
			$table->dropForeign('comunicacao_area_area_ID_foreign');
		});
		Schema::table('semiconf_logs', function(Blueprint $table) {
			$table->dropForeign('semiconf_logs_semiconf_ID_foreign');
		});
		Schema::table('semiconf_logs', function(Blueprint $table) {
			$table->dropForeign('semiconf_logs_utilizador_ID_foreign');
		});
		Schema::table('semiconf_autores', function(Blueprint $table) {
			$table->dropForeign('semiconf_autores_semiconf_ID_foreign');
		});
		Schema::table('semiconf_autores', function(Blueprint $table) {
			$table->dropForeign('semiconf_autores_utilizador_ID_foreign');
		});
		Schema::table('semiconf_grupos', function(Blueprint $table) {
			$table->dropForeign('semiconf_grupos_semiconf_ID_foreign');
		});
		Schema::table('semiconf_grupos', function(Blueprint $table) {
			$table->dropForeign('semiconf_grupos_grupo_ID_foreign');
		});
		Schema::table('semiconf_area', function(Blueprint $table) {
			$table->dropForeign('semiconf_area_semiconf_ID_foreign');
		});
		Schema::table('semiconf_area', function(Blueprint $table) {
			$table->dropForeign('semiconf_area_area_ID_foreign');
		});
		Schema::table('formacao_logs', function(Blueprint $table) {
			$table->dropForeign('formacao_logs_formacao_ID_foreign');
		});
		Schema::table('formacao_logs', function(Blueprint $table) {
			$table->dropForeign('formacao_logs_utilizador_ID_foreign');
		});
		Schema::table('formacao_autores', function(Blueprint $table) {
			$table->dropForeign('formacao_autores_formacao_ID_foreign');
		});
		Schema::table('formacao_autores', function(Blueprint $table) {
			$table->dropForeign('formacao_autores_utilizador_ID_foreign');
		});
		Schema::table('formacao_grupos', function(Blueprint $table) {
			$table->dropForeign('formacao_grupos_formacao_ID_foreign');
		});
		Schema::table('formacao_grupos', function(Blueprint $table) {
			$table->dropForeign('formacao_grupos_grupo_ID_foreign');
		});
		Schema::table('formacao_area', function(Blueprint $table) {
			$table->dropForeign('formacao_area_formacao_ID_foreign');
		});
		Schema::table('formacao_area', function(Blueprint $table) {
			$table->dropForeign('formacao_area_area_ID_foreign');
		});
		Schema::table('modelo_logs', function(Blueprint $table) {
			$table->dropForeign('modelo_logs_modelo_ID_foreign');
		});
		Schema::table('modelo_logs', function(Blueprint $table) {
			$table->dropForeign('modelo_logs_utilizador_ID_foreign');
		});
		Schema::table('modelo_area', function(Blueprint $table) {
			$table->dropForeign('modelo_area_modelo_ID_foreign');
		});
		Schema::table('modelo_area', function(Blueprint $table) {
			$table->dropForeign('modelo_area_area_ID_foreign');
		});
		Schema::table('modelo_grupos', function(Blueprint $table) {
			$table->dropForeign('modelo_grupos_modelo_ID_foreign');
		});
		Schema::table('modelo_grupos', function(Blueprint $table) {
			$table->dropForeign('modelo_grupos_grupo_ID_foreign');
		});
		Schema::table('modelo_autores', function(Blueprint $table) {
			$table->dropForeign('modelo_autores_utilizador_ID_foreign');
		});
	}
}