<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Voucher extends Model 
{

    protected $table = 'vouchers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('voucher_group_id', 'status_id', 'user_id', 'client_id');

    public function invoice_group()
    {
        return $this->hasOne('VoucherGroup');
    }

    public function status()
    {
        return $this->hasOne('VoucherStatus');
    }

    public function client()
    {
        return $this->hasOne('Client');
    }

}