<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVoucherStatusesTable extends Migration {

	public function up()
	{
		Schema::create('voucher_statuses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->text('description')->nullable();
			$table->enum('type', array('start', 'step', 'end'));
			$table->boolean('read_only');
		});
	}

	public function down()
	{
		Schema::drop('voucher_statuses');
	}
}