<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivitiesTable extends Migration {

	public function up()
	{
		Schema::create('activities', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->bigInteger('service_id')->unsigned();
			$table->string('duration');
			$table->integer('min_participants');
			$table->integer('max_participants');
			$table->decimal('price', 10,2);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('activities');
	}
}