<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->bigInteger('payment_id')->unsigned();
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('service_id')->unsigned();
			$table->bigInteger('island_id')->unsigned();
			$table->bigInteger('village_id')->unsigned();
			$table->string('name');
			$table->string('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}