<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccommodationBookingsTable extends Migration {

	public function up()
	{
		Schema::create('accommodation_bookings', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('service_id')->unsigned();
			$table->bigInteger('room_id')->unsigned();
			$table->datetime('check_in');
			$table->datetime('check_out');
			$table->decimal('total_price', 10,2);
			$table->integer('total_days');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('accommodation_bookings');
	}
}