<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivityBookingsTable extends Migration {

	public function up()
	{
		Schema::create('activity_bookings', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('service_id')->unsigned();
			$table->bigInteger('activity_id')->unsigned();
			$table->integer('num_participants');
			$table->decimal('total_price', 10,2);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('activity_bookings');
	}
}