<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->bigInteger('customer_id')->unsigned();
			$table->string('bill_id');
			$table->tinyInteger('paid');
			$table->datetime('paid_at');
			$table->integer('amount');
			$table->integer('paid_amount');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}