<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRoomsTable extends Migration {

	public function up()
	{
		Schema::create('rooms', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->string('name');
			$table->string('descriptions');
			$table->integer('max_guests');
			$table->decimal('price', 10,2);
			$table->integer('quantity');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('rooms');
	}
}