<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('user_role_id')->references('id')->on('user_roles')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('islands', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('villages', function(Blueprint $table) {
			$table->foreign('island_id')->references('id')->on('islands')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->foreign('village_id')->references('id')->on('villages')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('service_type_id')->references('id')->on('service_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('vendors')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('village_id')->references('id')->on('villages')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('island_id')->references('id')->on('islands')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('village_id')->references('id')->on('villages')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('accommodation_bookings', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('accommodation_bookings', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('accommodation_bookings', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('activity_bookings', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('activity_bookings', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('activity_bookings', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activities')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('image_type_id')->references('id')->on('image_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_user_role_id_foreign');
		});
		Schema::table('islands', function(Blueprint $table) {
			$table->dropForeign('islands_state_id_foreign');
		});
		Schema::table('villages', function(Blueprint $table) {
			$table->dropForeign('villages_island_id_foreign');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->dropForeign('vendors_village_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_service_type_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_vendor_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_village_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_customer_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_payment_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_customer_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_service_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_island_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_village_id_foreign');
		});
		Schema::table('accommodation_bookings', function(Blueprint $table) {
			$table->dropForeign('accommodation_bookings_customer_id_foreign');
		});
		Schema::table('accommodation_bookings', function(Blueprint $table) {
			$table->dropForeign('accommodation_bookings_service_id_foreign');
		});
		Schema::table('accommodation_bookings', function(Blueprint $table) {
			$table->dropForeign('accommodation_bookings_room_id_foreign');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->dropForeign('activities_service_id_foreign');
		});
		Schema::table('activity_bookings', function(Blueprint $table) {
			$table->dropForeign('activity_bookings_customer_id_foreign');
		});
		Schema::table('activity_bookings', function(Blueprint $table) {
			$table->dropForeign('activity_bookings_service_id_foreign');
		});
		Schema::table('activity_bookings', function(Blueprint $table) {
			$table->dropForeign('activity_bookings_activity_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_image_type_id_foreign');
		});
	}
}