<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('hotel_id')->unsigned();
			$table->integer('agency_id')->unsigned();
			$table->integer('route_id')->unsigned();
			$table->string('voucher_code', 20)->unique();
			$table->string('agent_name', 100)->nullable();
			$table->string('agent_phone', 20)->nullable();
			$table->date('date');
			$table->string('status', 50)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}