<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Hotel extends Eloquent {

	protected $table = 'hotels';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'address', 'description', 'enable');

	public function routes()
	{
		return $this->hasMany('Hotel_location', 'hotel_id');
	}

	public function reservations()
	{
		return $this->hasMany('Reservation', 'hotel_id');
	}

}