<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('field_code')->nullable();
			$table->string('major_field_code')->nullable();
			$table->string('sub_major_field_code')->nullable();
			$table->string('unit_field_code')->nullable();
			$table->string('specific_field_code')->nullable();
			$table->string('major_group_id')->nullable();
			$table->string('sub_major_group_id')->nullable();
			$table->string('minor_group_id')->nullable();
			$table->string('unit_group_id')->nullable();
			$table->float('job_id', 10,5)->nullable();
			$table->string('sin_job_name')->nullable();
			$table->string('eng_job_name')->nullable();
			$table->string('tam_job_name')->nullable();
			$table->integer('scale')->unsigned()->nullable();
			$table->string('organisation')->nullable();
			$table->string('location')->nullable();
			$table->text('sin_description')->nullable();
			$table->text('eng_description')->nullable();
			$table->text('tam_description')->nullable();
			$table->text('sin_traditional_description')->nullable();
			$table->text('eng_traditional_description')->nullable();
			$table->text('tam_traditional_description')->nullable();
			$table->string('profession_image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}