<?php

namespace App\Model;

class OrderModel extends Eloquent {

	protected $table = 'order';
	public $timestamps = true;
	protected $fillable = array('customer_id', 'shipping_id', 'payment_id', 'order_total', 'order_status', 'order_date');
	protected $visible = array('customer_id', 'shipping_id', 'payment_id', 'order_total', 'order_status', 'order_date');

	public function paymentof()
	{
		return $this->belongsTo('PaymentModel');
	}

	public function orderDetails()
	{
		return $this->hasMany('OrderDetailsModel');
	}

	public function customerof()
	{
		return $this->belongsTo('CustomerModel');
	}

	public function orderDetails()
	{
		return $this->belongsTo('ShippingModel');
	}

}