<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->increments('product_id');
			$table->string('product_name', 255);
			$table->string('image', 255);
			$table->integer('category_id')->unsigned()->index();
			$table->integer('brand_id')->unsigned()->index();
			$table->string('width', 255);
			$table->string('height', 255);
			$table->text('description');
			$table->string('product_price', 255);
			$table->integer('quantity');
			$table->string('url', 255);
			$table->enum('status', array('Active', 'Deleted'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}