<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidaturesTable extends Migration {

	public function up()
	{
		Schema::create('candidatures', function(Blueprint $table) {
			$table->increments('id');
			$table->string('prenom');
			$table->string('nom');
			$table->string('civilite');
			$table->string('email');
			$table->string('telephone');
			$table->string('curriculum_vitae');
			$table->boolean('is_accepted')->default(0);
			$table->boolean('is_refused')->default(0);
			$table->boolean('is_spontaneus')->default(0);
			$table->integer('offres_id');
			$table->longText('motivation')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('candidatures');
	}
}