<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 100);
			$table->string('last_name', 100);
			$table->string('password', 255);
			$table->integer('gender_id')->unsigned();
			$table->integer('user_role_id')->unsigned();
			$table->string('phone', 25)->nullable()->default('NULL');
			$table->string('nationality', 50)->nullable();
			$table->string('home_address', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}