<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('first_name', 'last_name', 'user_role_id', 'phone', 'nationality', 'home_address');

	public function gender()
	{
		return $this->belongsTo('UserGender', 'gender_id');
	}

	public function tutor()
	{
		return $this->morphOne('App\Models\UserTutor');
	}

	public function student()
	{
		return $this->morphOne('UserStudent');
	}

	public function role()
	{
		return $this->belongsTo('UserStatus', 'user_id');
	}

	public function chats()
	{
		return $this->hasOne('ChatUsers', 'user_id');
	}

}