<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersAffiliatesTable extends Migration {

	public function up()
	{
		Schema::create('users_affiliates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('first_user_id');
			$table->integer('second_user_id');
			$table->string('third_user_id');
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->string('admin_delete');
			$table->enum('delete_status', array('0', '1'));
			$table->enum('status', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('users_affiliates');
	}
}