<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name_ar');
			$table->string('name_en');
			$table->string('page_title_en');
			$table->string('page_title_ar');
			$table->string('meta_keywords_en');
			$table->string('meta_keywords_ar');
			$table->string('meta_description_en');
			$table->string('meta_description_ar');
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->integer('admin_delete');
			$table->enum('delete_status', array('0', '1'));
			$table->enum('status', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}