<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersSecurityTable extends Migration {

	public function up()
	{
		Schema::create('users_security', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('delete_status', array('0', '1'));
			$table->integer('user_id')->unsigned();
			$table->string('ip');
			$table->enum('status', array('0', '1'));
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->integer('admin_delete');
		});
	}

	public function down()
	{
		Schema::drop('users_security');
	}
}