<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWithdrawTable extends Migration {

	public function up()
	{
		Schema::create('withdraw', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('amount');
			$table->integer('status');
			$table->integer('payment_type');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->integer('admin_delete');
			$table->enum('delete_status', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('withdraw');
	}
}