<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNetworkApiCredentialsTable extends Migration {

	public function up()
	{
		Schema::create('network_api_credentials', function(Blueprint $table) {
			$table->increments('id', true)->primary();
			$table->integer('customer_id')->unsigned();
			$table->smallInteger('network_id')->unsigned();
			$table->string('account_id');
			$table->string('app_id');
			$table->string('api_key');
			$table->string('access_token');
			$table->tinyInteger('Status')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('network_api_credentials');
	}
}